# FORCE_EFI_BOOT

echo -off
# +
# + ============================================================== +
#  Copyright (c) 2023, Intel Corporation.

#  This source code and any documentation accompanying it ("Material") is furnished
#  under license and may only be used or copied in accordance with the terms of that
#  license.  No license, express or implied, by estoppel or otherwise, to any
#  intellectual property rights is granted to you by disclosure or delivery of these
#  Materials.  The Materials are subject to change without notice and should not be
#  construed as a commitment by Intel Corporation to market, license, sell or support
#  any product or technology.  Unless otherwise provided for in the license under which
#  this Material is provided, the Material is provided AS IS, with no warranties of
#  any kind, express or implied, including without limitation the implied warranties
#  of fitness, merchantability, or non-infringement.  Except as expressly permitted by
#  the license for the Material, neither Intel Corporation nor its suppliers assumes
#  any responsibility for any errors or inaccuracies that may appear herein.  Except
#  as expressly permitted by the license for the Material, no part of the Material
#  may be reproduced, stored in a retrieval system, transmitted in any form, or
#  distributed by any means without the express written consent of Intel Corporation.

#  Module Name:  Startup.nsh

#  Abstract:  UEFI Script file for invoking system software updates for 
#  Intel(R) Server Board S2600ST(R) Family


@echo -off
mode 80 25
:foundimage section is simply to locate the correct drive
if exist .\ipmi.efi then
 goto FOUNDIMAGE
endif
if exist fs0:\ipmi.efi then
 fs0:
 echo Found Update Packages on fs0:
 goto FOUNDIMAGE
endif
if exist fs1:\ipmi.efi then
 fs1:
 echo Found Update Packages on fs1:
 goto FOUNDIMAGE
endif
if exist fs2:\ipmi.efi then
 fs2:
 echo Found Update Packages on fs2:
 goto FOUNDIMAGE
endif
 echo "Unable to find Update Packages".  
 echo "Please mount the drive with the update package".
 echo ""
 goto END
:FOUNDIMAGE


echo "==============================================================================="
echo " "
echo "This utility will update the BMC firmware, BIOS, ME, FD firmware and FRUSDR"
echo " "
echo "      - Intel(R) Server Board S2600ST(R) Family"
echo " "
echo "If you have not read the Readme and Update Instructions file,"
echo "it is highly advisable you do that before continuing with this update."
echo " "
echo "During the full update process, the system will reboot one times."
echo "Do NOT power off the system or remove the USB flash drive at any time during"
echo "this process. Doing so may render your system inoperable."
echo " "
echo "Please make sure no *.tmp exists on the USB key before starting update process"
echo " "
echo " "
echo "==============================================================================="

# Notification
     echo " ......................Please wait................................."
     echo "Reading Current FW on board..."
     iflash32.efi -i
echo " "
echo "==============================================================================="
echo "Update Sequence:"
echo "1. BMC - No SUT reset after update completes"
echo "2. ME  - No SUT reset after update completes"
echo "3. BIOS- No SUT reset after update completes"
echo "4. FD  - No SUT reset after update completes"
echo "5. FRUSDR - No SUT reset after update completes"
echo " "
echo "!!! Steps 1-5 will be completed at the first time startup.nsh is invoked !!!"
echo "Reset SUT to make updated firmware effective."
echo "See the Readme and Update Instructions file for additional information."
echo " "
echo "==============================================================================="
echo "BMC --> ME --> BIOS --> FD --> FRUSDR -> RESET"
echo " "
stall 3000000

:A
 
if exist BMC_pass.tmp then 
    if exist ME_pass.tmp then 
        if exist BIOS_pass.tmp then 
            if exist FD_pass.tmp then
                if exist FRUSDR_pass.tmp then 
                    goto Final
        else
            goto FRUSDR
        endif
    else
        goto FD
    endif
else 
    goto BIOS
endif
    else
        goto ME
    endif
else 
    goto BMC
endif




:BMC
echo " "
echo "DO NOT remove the USB flash drive"
echo " "
echo " "

#Update BMC
fwUpdateBMC.nsh

echo " "
echo "BMC Firmware update has been completed" > BMC_pass.tmp
echo " "

stall 2000000
goto A

:BIOS
echo " "
echo "==============================================================================="
echo "Continuing system BIOS update......"
echo "DO NOT remove the USB flash drive"
echo " "
echo " "

#Update BIOS
UpdBIOS.nsh


echo " "
echo "BIOS Firmware update has been completed" > BIOS_pass.tmp
echo " "

stall 2000000
goto A

:FD
echo " "
echo "==============================================================================="
echo "Continuing system Flash Description update......"
echo " "
echo " "

UpdFD.nsh

echo " "
echo "FD update has been completed" > FD_pass.tmp
echo " "
echo "==============================================================================="
echo "DO NOT remove the USB flash drive"
echo " "
echo "==============================================================================="
stall 2000000
goto A

:FRUSDR
echo " "
echo "==============================================================================="
echo "Continuing system FRUSDR update......"
echo " "
echo " "
UpdS2600ST.nsh

echo " "
echo "System FRU & SDR data have successfully been updated" > FRUSDR_pass.tmp
stall 2000000
goto A

:ME
echo " "
echo "==============================================================================="
echo "Continuing system ME update......"
echo "DO NOT remove the USB flash drive"
echo " "
echo "==============================================================================="
echo " "
echo " "

#Update ME
UpdMe.nsh

echo " "
echo "ME Firmware update has been completed." > ME_pass.tmp
echo " "
echo
stall 2000000
goto A

:Final
rm BMC_pass.tmp > nul 
rm BIOS_pass.tmp > nul 
rm FRUSDR_pass.tmp > nul
rm FD_pass.tmp > nul
rm ME_pass.tmp > nul

echo " "
echo "==============================================================================="
echo "All system updates have been completed now"
echo " "
echo "Now the USB Key can be removed and the system can be restarted."
echo "There is one time SUT reset after backup bios is updated successfully."
echo "After that, access the BIOS Setup utility via pressing <F2> during POST"
echo "to confirm all updates have been installed properly."

:END
 